<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include"template/include/aspetto/{$aspettoSito["cartellaMenu"]}/menuPrincipale.php";
?>
   
    <!-- Inizio contenuto pagina -->
    <main role="main">
        <section class="ecommerce siOverflow">

            <div class="container">
                <div class="row">
                    <?php
                        include "template/include/ecommerce/breadcrumb.php";
                    ?>
                    
			<div class="col-md-8 col-xl-9">
                            <div class="row">
                                <!-- Articolo -->
                                <div class="col-lg-6 mb-5">
                                    <?php
                                        if($prodotto["prezzoOfferta"]>0) {
                                            echo"<span class=\"in-offerta\"></span>";
                                        }
                                    ?>
                                    <div class="owl-carousel owl-theme prodotto-slider">
                                        <?php 
                                            $queryNomiGruppi = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE 'immagineProdotto' AND idContenuto={$prodotto["id"]} ORDER BY posizione ASC";
                                            $risImmagini = $geecomDb->eseguiQueryLettura($queryNomiGruppi);
                                            if($risImmagini->num_rows>0) {
                                                while($immagine = $risImmagini->fetch_assoc()) {
                                                    echo"<a href=\"{$immagine["percorso"]}\"
                                                        data-toggle=\"lightbox\" 
                                                        data-gallery=\"nome-della-galleria\" 
                                                        data-title=\"{$prodotto["nome"]}\" 
                                                        data-footer=\"{$immagine["descrizione"]}\">
                                                        <div class=\"aspect-ratio-4-3\">
                                                            <img src=\"{$immagine["percorso"]}\" class=\"img-fluid\">
                                                        </div>
                                                    </a>";
                                                }
                                            }
                                            else if($prodotto["immagine"]!="") {
                                                echo"<a href=\"{$prodotto["immagine"]}\"
                                                        data-toggle=\"lightbox\" 
                                                        data-gallery=\"nome-della-galleria\" 
                                                        data-title=\"{$prodotto["nome"]}\" 
                                                        data-footer=\"\">
                                                        <div class=\"aspect-ratio-4-3\">
                                                            <img src=\"{$prodotto["immagine"]}\" class=\"img-fluid\">
                                                        </div>
                                                    </a>";
                                            }
                                            else {
                                                echo"<a href=\"immagini/altro/segnaposto.png\"
                                                        data-toggle=\"lightbox\" 
                                                        data-gallery=\"nome-della-galleria\" 
                                                        data-title=\"{$prodotto["nome"]}\" 
                                                        data-footer=\"\">
                                                        <div class=\"aspect-ratio-4-3\">
                                                            <img src=\"immagini/altro/segnaposto.png\" class=\"img-fluid\"> <!--/thumbnail-->
                                                        </div>
                                                     </a>";
                                            }
                                        ?>
                                    </div>
                                    <div id="condividiOrizzontale" class="ml-0">
                                        <?php 
                                            include "template/include/contenuti/condivisioniSocial.php";
                                        ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-5">
                                    <?php
                                        // includo la seconda colonna se è posizionata a destra
                                        if($impostazioniEcommerce["posizioneBarraLaterale"]=="sinistra") {
                                            $classeColonnaPrincipale = "order-md-1";
                                        }
                                        else {
                                            $classeColonnaPrincipale = "order-md-0";
                                        }
                                    ?>
                                    <h1 class="mb-3"><?php echo $prodotto["nome"]; ?></h1>
                                    <?php 
                                    	  if($prodotto["ean"]!="" && $impostazioniEcommerce["mostraEanPaginaProdotto"]=="si") {
						?>                                        
                                              <p><b>EAN:</b><?= $prodotto["ean"] ?></p>
                                              <?php
                                        }
                                        
                                        if($prodotto["categoria"]!=0) {
                                            $categoria = $geecomDb->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                                            $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoria,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                                            echo"<a href=\"$linkCategoria\" class=\"badge badge-primary rounded-0 py-2 px-3 mb-2\">{$categoria["nome"]}</a>";
                                        }
                                        
                                        $testo = explode("<!-- leggi tutto -->",$prodotto["descrizione"]);
                                        echo $testo[0]; 
                                    ?>
                                        <div class="row mb-3">
                                            <div class="col">
                                                <?php
                                                    $prezzoBase    = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzo"] + ($prodotto["prezzo"] * $prodotto["iva"] / 100) : $prodotto["prezzo"];
                                                    $prezzoOfferta = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzoOfferta"] + ($prodotto["prezzoOfferta"] * $prodotto["iva"] / 100) : $prodotto["prezzoOfferta"];
                                                    $asterisco     = "";
                                                    
                                                    // imposto il suffisso IVA
                                                    if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA esclusa") {
                                                        $suffissoIva = $gestoreTraduzioni->traduci("+ IVA",$prodotto["lingua"]);
                                                    }
                                                    else if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") {
                                                        $suffissoIva = $gestoreTraduzioni->traduci("IVA inclusa",$prodotto["lingua"]);
                                                    }
                                                    else {
                                                        $suffissoIva = "";
                                                    }
                                                    
                                                    if($datiGruppo != null) {
                                                        $prezzoBase    = round($prezzoBase - ($prezzoBase * $datiGruppo["percentualeSconto"] / 100),2);
                                                        $prezzoOfferta = ($prezzoOfferta!=0) ? round($prezzoOfferta - ($prezzoOfferta * $datiGruppo["percentualeSconto"] / 100),2) : 0;
                                                        $asterisco = "*";
                                                    }
                                                    // inizializza la variabile prezzoProdotto (serve in vari punti sotto)
                                                    if($prezzoOfferta>0) {
                                                        $prezzoPodotto = $prezzoOfferta;
                                                    }
                                                    else {
                                                        $prezzoPodotto = $prezzoBase;
                                                    }
                                                ?>
                                                <input id="inputPrezzoProdotto" class="d-none" value="<?php echo $prezzoPodotto; ?>">
                                                <?php 
                                                    if($prodotto["usaVariazioni"]=="si") {
                                                        $queryVariazionePiuEconomica  = "SELECT * FROM geecEc_variazioniProdotto WHERE idProdotto ={$prodotto["id"]} ORDER BY costo ASC LIMIT 1";
                                                        $risVariazionePiuEconomica     = $geecomDb->eseguiQueryLettura($queryVariazionePiuEconomica);
                                                        $datiVariazionePiuEconomica    = $risVariazionePiuEconomica->fetch_assoc();
                                                        $prezzoVariazionePiuEconomica  = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $datiVariazionePiuEconomica["costo"] + ($datiVariazionePiuEconomica["costo"] * $prodotto["iva"] / 100) : $datiVariazionePiuEconomica["costo"];
                                                        echo"<h4 id=\"labelPrezzoProdotto\" class=\"text-primary mb-0 mt-3\"><strong>A partire da $prezzoVariazionePiuEconomica € </strong> <small>$suffissoIva</small></h4>";
                                                    }
                                                    else {
                                                        if($prodotto["prezzoOfferta"]>0) {
                                                              echo"<h4 id=\"labelPrezzoProdotto\" class=\"text-primary mb-0 mt-3\"><strong> $prezzoPodotto € </strong> <small>$suffissoIva</small></h4>";
                                                              echo"<h6 class=\"text-muted\"><del>{$prodotto["prezzo"]} € <small>$suffissoIva</small></del></h6>";
                                                        }
                                                        else {
                                                              echo"<h4 id=\"labelPrezzoProdotto\" class=\"text-primary mb-0 mt-3\"><strong> $prezzoPodotto € </strong> <small>$suffissoIva</small></h4>";
                                                        }
                                                    }
                                                ?>
                                            </div>
                                        </div>
                                        <?php 
                                            // se mostraPezziRimanenti == si, non è un prodotto inesauribile e non è un prodotto con variazioni mostra la quantità in magazzino
                                            if($prodotto["prodottoInesauribile"]=="no" && $prodotto["usaVariazioni"]!="si") {
                                                if($prodotto["disponibilita"]>0) {
                                                 	if($impostazioniEcommerce["mostraPezziRimanenti"]=="si") {
				                        ?>
							    <div class="clearfix mb-2 text-success">
				                                <small><strong><?php echo $prodotto["disponibilita"]; ?>  <?php echo $gestoreTraduzioni->traduci("pz in magazzino",$lingua) ?></strong></small>
				                            </div>
				                         <?php
                                                 	}
                                                }
                                                else {
                                        ?>
                                            <div class="clearfix mb-2 text-danger">
                                                <small><strong><?php echo $gestoreTraduzioni->traduci("Questo articolo non è al momento disponibile",$lingua) ?></strong></small>
                                            </div>
                                        <?php
                                                }
                                            }
                                        ?>
                                       <form>
                                       
                                            <?php 
                                                if($impostazioniEcommerce["mostraSelettoreQuantita"]=="si"  && $prodotto["usaVariazioni"]!="si") {
                                            ?>
                                                    <div class="d-flex justify-content-between mb-3">
                                                        <label class="my-1 mr-2" for="quantita"><strong><?php echo $gestoreTraduzioni->traduci("Quantità",$lingua) ?></strong></label>
                                                        <input type="number" class="form-control" name="quantita" id="quantita" min="<?php echo $prodotto["minimoAcquisto"] ?>" value="<?php echo $prodotto["minimoAcquisto"] ?>">
                                                    </div>
                                            <?php 
                                                }
                                                else {
                                                        echo"<input type=\"number\" class=\"d-none\" name=\"quantita\" id=\"quantita\" value=\"1\">";
                                                }
                                                
                                                if($prodotto["usaVariazioni"]=="si") {
                                                        $elencoAttributi = ""; // il campo attributo in questo caso non viene usato
                                                        
                                                        $queryVariazioni = "SELECT * FROM geecEc_variazioniProdotto WHERE idProdotto ={$prodotto["id"]}";
		                                        $risVariazioni = $geecomDb->eseguiQueryLettura($queryVariazioni);
		                                    ?>
						            <label for="quantita">Seleziona versione </label>
						            <div class="form-group">
						                <select class="form-control" id="variazioneProdotto<?= $prodotto["id"] ?>" onchange="aggiornaPrezzoVariante(<?= $prodotto["id"] ?>)">
						                    <?php 
									while($variazione = $risVariazioni->fetch_assoc()) {
							                    $prezzoVariazione = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $variazione["costo"] + ($variazione["costo"] * $prodotto["iva"] / 100) : $variazione["costo"];
							                    echo"<option value=\"{$variazione["id"]}\" >{$variazione["nome"]} ({$prezzoVariazione} €)</option>";
							                }
						                    ?>
                                                                </select>
						            </div>
		                                    <?php
                                                }
                                                else {
                                                    $numeroAttributi = 0;
                                                    $attributoTmp    = array();
                                                    $queryAttributi = "SELECT * FROM geecEc_attributiProdotto WHERE idProdotto ={$prodotto["id"]}";
                                                    $risAttributi = $geecomDb->eseguiQueryLettura($queryAttributi);
                                                    while($attributo = $risAttributi->fetch_assoc()) {
                                                        $attributoTmp   = $attributo;
                                                        $arrayAttributi = explode(",",$attributo["valori"]);
                                                        $arrayPrezzi    = explode(",",$attributo["costi"]);
                                                ?>
                                                        <label for="quantita"><?php echo $attributo["nome"]; ?></label>
                                                        <div class="form-group">
                                                            <select class=form-control id="<?= $attributo["nome"]; ?>" name="<?= $attributo["nome"]; ?>">
                                                                <option value="">Seleziona</option>
                                                                <?php 
                                                                        $i = 0;
                                                                    foreach($arrayAttributi as $valoreAttributo) {
                                                                        echo"<option value=\"$valoreAttributo\" onclick=\"aggiornaPrezzoProdottoInBaseAllAttributo({$arrayPrezzi[$i]})\">$valoreAttributo</option>";
                                                                             $i ++;
                                                                    }
                                                                ?>
                                                             </select>
                                                        </div>
                                                <?php 
                                                        $numeroAttributi++;
                                                    }

                                                    if($numeroAttributi==0) {// se il prodotto non ha attributi ne viene creato uno vuoto per evitare errori in fase di aggiunta al carrello riga 210
                                                        $attributo = array("nome"=>""); 
                                                    }
                                                    else {
                                                        $attributo = $attributoTmp;
                                                    }
                                                }
                                            ?>
                                    </form>
                                    <?php 
                                        if($impostazioniEcommerce["messaggioPulsanteCarrelloPaginaProdotti"]!="") {
                                    ?>
                                    <div class="bg-light p-3 border mb-3"><?= $impostazioniEcommerce["messaggioPulsanteCarrelloPaginaProdotti"] ?></div>
                                    <?php 
                                        }
                                        
                                        if($impostazioniEcommerce["bloccaAcquisti"]!="si") {
                                    ?>
                                            <button class="btn btn-outline-primary btn-block sharp aggiungi" onclick="aggiungiAlCarrelloPaginaProdotto('prodottoEcommerce',<?php echo $prodotto["id"]; ?>,'<?php echo $attributo["nome"]; ?>','<?php echo $prodotto["nome"]; ?>','<?php echo $prodotto["immagine"]; ?>',<?php echo(($prodotto["prodottoInesauribile"]=="si") ? "10000" : $prodotto["disponibilita"]); ?>,'<?php echo $prodotto["usaVariazioni"] ?>')" ><?php echo $gestoreTraduzioni->traduci("Aggiungi al carrello",$lingua) ?></button>
                                    <?php
                                            if($impostazioniEcommerce["mostraTempoNecessarioConsegna"]=="si") {
                                                $query = "SELECT * FROM geecEc_metodiSpedizione ORDER BY giorniNecessari DESC LIMIT 1";
                                                $risSpedizioni = $geecomDb->eseguiQueryLettura($query);

                                                $spedizione = $risSpedizioni->fetch_assoc();

                                                if(date("D")=="Sun" && $spedizione["giorniInCuiSiSpedisce"]!="Tutti i giorni") {
                                                  $spedizione["giorniNecessari"] ++;
                                                }

                                                if(date("D")=="Sat" && $spedizione["giorniInCuiSiSpedisce"]!="Tutti i giorni") {
                                                  $spedizione["giorniNecessari"] ++;
                                                }

                                                $arrayOrarioLimite = explode(":", $spedizione["orarioLimite"]);
                                                if((date("H") == $arrayOrarioLimite[0] &&  date("i") >= $arrayOrarioLimite[1]) || date("H") > $arrayOrarioLimite[0]) {
                                                    $spedizione["giorniNecessari"] ++;
                                                }

                                                if($spedizione["giorniNecessari"]==1) {
                                                  $dataConsegna = date("d/m/Y",strtotime("+1 day"));
                                                }
                                                else {
                                                  $dataConsegna = date("d/m/Y",strtotime("+{$spedizione["giorniNecessari"]} days"));
                                                }
                                        ?>
                                                <p><b><?= str_replace("__data__",$dataConsegna,$impostazioniEcommerce["fraseTempoNecessarioConsegna"]) ?></b></p>
                                        <?php
                                            }
                                        }
                                    ?>
                                </div>           
                            </div>
                            <div class="tab-component">
                                <nav>
                                    <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                        <a class="nav-item nav-link active" id="nav-descrizione-tab" data-toggle="tab" href="#nav-descrizione" role="tab" aria-controls="nav-descrizione" aria-selected="true"><i class="fas fa-align-justify"></i> Descrizione</a>
                                        <a class="nav-item nav-link" id="nav-dettagli-tab" data-toggle="tab" href="#nav-dettagli" role="tab" aria-controls="nav-dettagli" aria-selected="false"><i class="fas fa-info-circle"></i> Dettagli</a>
                                    </div>
                                </nav>

                                <!-- Contenuto tabs -->
                                <div class="tab-content" id="nav-tabContent">
                                    <div class="tab-pane fade show active" id="nav-descrizione" role="tabpanel" aria-labelledby="nav-descrizione-tab">
                                        <div class="block" > 
                                            <?php echo $prodotto["descrizione"]; ?>
                                        </div>

                                    </div>
                                    <div class="tab-pane fade" id="nav-dettagli" role="tabpanel" aria-labelledby="nav-dettagli-tab">
                                        <table class="table table-hover table-responsive mb-0">
                                            <tbody>
                                                <?php 
                                                    $arrayCaratteristicheStringhe  = ["marca","modello","formato","materiale","capacità","colore"];;
                                                    $arrayCaratteristicheNumeriche = ["altezza","profondità","peso"];
                                                    foreach($arrayCaratteristicheStringhe as $caratteristica) {
                                                        if($prodotto[$caratteristica]!="") {
                                                            stampaEtichettaProdotto(ucfirst($caratteristica),$prodotto[$caratteristica]);
                                                        }
                                                    }

                                                    foreach($arrayCaratteristicheNumeriche as $caratteristica) {
                                                        if($prodotto[$caratteristica]!=0) {
                                                            stampaEtichettaProdotto(ucfirst($caratteristica),$prodotto[$caratteristica]);
                                                        }
                                                    }
                                                ?>
                                            </tbody>	
                                        </table>
                                    </div>
                                    
                                    <div class="mt-4">
                                        <?php 
                                            include "template/include/ecommerce/raccomandazioniProdotti.php";
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div><!--/item-->

                        
			<?php
                            if($impostazioniEcommerce["posizioneBarraLaterale"]=="sinistra") {
                                 $classeColonnaLaterale = "order-md-0";
                            }
                            else {
                                 $classeColonnaLaterale = "order-md-1";
                            }
                            
                            VisualizzatorePannelloLaterale::stampa($geecomDb, $impostazioni, $configurazioneAspetto,"destra",$lingua);
			?>
                </div>
            </div><!--/#colonna principale-->
        </section>
        
        <div id="contenitoreComponenti">
            <?php
                UtilTemplate::stampaComponenti($geecomDb, $gestoreJavascript, $impostazioni, $prodotto["id"],$gestoreTraduzioni,$lingua,"prodotto");
            ?>
        </div>
    </main>
    <?php 
	include "template/include/aspetto/{$aspettoSito["cartellaFooter"]}/footer.php";
